<?php
/*======================================================================*\
|| #################################################################### ||
|| # Advanced Product Management [APM] v4.0.001  by HacNho             # ||
|| # Copyright (C) 2005 by HacNho, All rights reserved.               # ||
|| # ---------------------------------------------------------------- # ||
|| # For use with vBulletin Version 4.0.x                             # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| # ---------------------------------------------------------------- # ||
|| # Discussion and support available at                              # ||
|| # http://www.vbulletin.org/forum/showthread.php?t=229418           # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
@set_time_limit(0);
ignore_user_abort(true);

if ($_POST['do'] == 'updatetemplate' OR $_POST['do'] == 'inserttemplate' OR $_REQUEST['do'] == 'createfiles')
{
	// double output buffering does some weird things, so turn it off in these three cases
	DEFINE('NOZIP', 1);
}

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('style');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminstyles'))
{
	print_cp_no_permission();
}

$vbulletin->input->clean_array_gpc('r', array(
	'templateid'   => TYPE_INT,
	'dostyleid'    => TYPE_INT,
));

// ############################# LOG ACTION ###############################
log_admin_action(!empty($vbulletin->GPC['templateid']) ? 'template id = ' . $vbulletin->GPC['templateid'] : !empty($vbulletin->GPC['dostyleid']) ? 'style id = ' . $vbulletin->GPC['dostyleid'] : '');

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'modify';
}
else
{
	$nozipDos = array('inserttemplate', 'rebuild', 'kill', 'insertstyle', 'killstyle', 'updatestyle');
	if (in_array($_REQUEST['do'], $nozipDos))
	{
		$vbulletin->nozip = true;
	}
}

$full_product_info = fetch_product_list(true);

if ($_REQUEST['do'] != 'download')
{
	print_cp_header($vbphrase['style_manager'], iif($_REQUEST['do'] == 'files', 'js_fetch_style_title()'));
	?><script type="text/javascript" src="../clientscript/vbulletin_templatemgr.js?v=<?php echo SIMPLE_VERSION; ?>"></script><?php
}



// #############################################################################
// view the history of a template, including old versions and diffs between versions
if ($_REQUEST['do'] == 'history')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'title' => TYPE_STR
	));

	$revisions = array();
	$have_cur_def = false;
	$cur_temp_time = 0;

	$current_temps = $db->query_read("
		SELECT templateid, title, styleid, dateline, username, version
		FROM " . TABLE_PREFIX . "template
		WHERE title = '" . $db->escape_string($vbulletin->GPC['title']) . "'
			AND styleid IN (-1, " . $vbulletin->GPC['dostyleid'] . ")
	");
	while ($template = $db->fetch_array($current_temps))
	{
		$template['type'] = 'current';

		// the point of the second part of this key is to prevent dateline
		// collisions, as rare as that may be
		$revisions["$template[dateline]|b$template[templateid]"] = $template;

		if ($template['styleid'] == -1)
		{
			$have_cur_def = true;
		}
		else
		{
			$cur_temp_time = $template['dateline'];
		}
	}

	$historical_temps = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "templatehistory
		WHERE title = '" . $db->escape_string($vbulletin->GPC['title']) . "'
			AND styleid IN (-1, " . $vbulletin->GPC['dostyleid'] . ")
	");
	$history_count = $db->num_rows($historical_temps);
	while ($template = $db->fetch_array($historical_temps))
	{
		$template['type'] = 'historical';

		// the point of the second part of this key is to prevent dateline
		// collisions, as rare as that may be
		$revisions["$template[dateline]|a$template[templatehistoryid]"] = $template;
	}

	// I used a/b above, so current versions sort above historical versions
	usort($revisions, "history_compare");

	print_form_header('template', 'historysubmit');
	print_table_header(construct_phrase($vbphrase['history_of_template_x'], htmlspecialchars_uni($vbulletin->GPC['title'])), 7);
	print_cells_row(array(
		($history_count ? $vbphrase['delete'] : ''),
		$vbphrase['type'],
		$vbphrase['version'],
		$vbphrase['last_modified'],
		$vbphrase['view'],
		$vbphrase['old'],
		$vbphrase['new']
	), true, false, 1);

	$have_left_sel = false;
	$have_right_sel = false;

	foreach ($revisions AS $revision)
	{
		$left_sel = false;
		$right_sel = false;

		if ($revision['type'] == 'current')
		{
			// we are marking this entry (ignore all other entries)
			if ($revision['styleid'] == -1)
			{
				$type = $vbphrase['current_default'];
			}
			else
			{
				$type = $vbphrase['current_version'];
			}

			if ($have_right_sel)
			{
				$left_sel = ' checked="checked"';
				$have_left_sel = true;
			}
			else
			{
				$right_sel = ' checked="checked"';
				$have_right_sel = true;
				if (sizeof($revisions) == 1)
				{
					$left_sel = ' checked="checked"';
					$left_sel_sel = true;
				}
			}

			$id = $revision['templateid'];
			$deletebox = '&nbsp;';
		}
		else
		{
			if ($revision['styleid'] == '-1')
			{
				$type = $vbphrase['old_default'];
			}
			else
			{
				$type = $vbphrase['historical'];
			}

			$id = $revision['templatehistoryid'];
			$deletebox = '<input type="checkbox" name="delete[]" value="' . $id . '" />';
		}

		if (!$revision['version'])
		{
			$revision['version'] = '<i>' . $vbphrase['unknown'] . '</i>';
		}

		$date = vbdate($vbulletin->options['dateformat'], $revision['dateline']);
		$time = vbdate($vbulletin->options['timeformat'], $revision['dateline']);
		$last_modified = "<i>$date $time</i> / <b>$revision[username]</b>";

		$view_link = construct_link_code($vbphrase['view'], "apm_template.php?$session[sessionurl]do=viewversion&amp;id=$id&amp;type=$revision[type]");

		$left = '<input type="radio" name="left_template" tabindex="1" value="' . "$id|$revision[type]" . "\"$left_sel />";
		$right = '<input type="radio" name="right_template" tabindex="1" value="' . "$id|$revision[type]" . "\"$right_sel />";

		if ($revision['comment'])
		{
			$comment = htmlspecialchars_uni($revision['comment']);

			$type = "<div title=\"$comment\">$type*</div>";
			$last_modified = "<div title=\"$comment\">$last_modified</div>";
			$revision['version'] = "<div title=\"$comment\">$revision[version]</div>";
			$view_link = "<div title=\"$comment\">$view_link</div>";
		}

		print_cells_row(array(
			$deletebox,
			$type,
			$revision['version'],
			$last_modified,
			$view_link,
			$left,
			$right
		), false, false, 1);
	}

	construct_hidden_code('wrap', 1);
	construct_hidden_code('inline', 1);
	construct_hidden_code('dostyleid', $vbulletin->GPC['dostyleid']);
	construct_hidden_code('title', $vbulletin->GPC['title']);

	print_description_row(
		'<span style="float:' . vB_Template_Runtime::fetchStyleVar('right') . '"><input type="submit" class="button" tabindex="1" name="docompare" value="' . $vbphrase['compare_versions'] . '" /></span>' .
		($history_count ? '<input type="submit" class="button" tabindex="1" name="dodelete" value="' . $vbphrase['delete'] . '" />' : '&nbsp;'), false, 7, 'tfoot');
	print_table_footer();

	echo '<div align="center" class="smallfont">' . $vbphrase['entry_has_a_comment'] . '</div>';
}

// #############################################################################
// generate a diff between two templates (current or historical versions)
if ($_REQUEST['do'] == 'viewversion')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'id' => TYPE_UINT,
		'type' => TYPE_STR
	));

	$template = fetch_template_current_historical($vbulletin->GPC['id'], $vbulletin->GPC['type']);

	if ($template['templateid'])
	{
		$type = ($template['styleid'] == -1 ? $vbphrase['current_default'] : $vbphrase['current_version']);
	}
	else
	{
		$type = ($template['styleid'] == -1 ? $vbphrase['old_default'] : $vbphrase['historical']);
	}

	$date = vbdate($vbulletin->options['dateformat'], $template['dateline']);
	$time = vbdate($vbulletin->options['timeformat'], $template['dateline']);
	$last_modified = "<i>$date $time</i> / <b>$template[username]</b>";

	print_form_header('', '');
	print_table_header(construct_phrase($vbphrase['viewing_version_of_x'], htmlspecialchars_uni($template['title'])));
	print_label_row($vbphrase['type'], $type);
	print_label_row($vbphrase['last_modified'], $last_modified);
	if ($template['version'])
	{
		print_label_row($vbphrase['version'], $template['version']);
	}
	if ($template['comment'])
	{
		print_label_row($vbphrase['comment'], $template['comment']);
	}
	print_description_row('<textarea class="code" style="width:95%; height:500px">' . htmlspecialchars_uni($template['templatetext']) . '</textarea>', false, 2, '', 'center');
	print_table_footer();

}

// #############################################################################
// just a small action to figure out which submit button was pressed
if ($_POST['do'] == 'historysubmit')
{
	$vbulletin->input->clean_array_gpc('p', array('dodelete' => TYPE_STR));

	if ($vbulletin->GPC['dodelete'])
	{
		$_POST['do'] = 'dodelete';
	}
	else
	{
		$_POST['do'] = 'docompare';
	}
}

// #############################################################################
// delete history points
if ($_POST['do'] == 'dodelete')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'delete' => TYPE_ARRAY_INT,
		'dostyleid' => TYPE_INT,
		'title' => TYPE_STR,
		'showtemplates' => TYPE_UINT,
	));

	if ($vbulletin->GPC['delete'])
	{
		$ids = implode(', ', $vbulletin->GPC['delete']);

		$db->query_write("DELETE FROM " . TABLE_PREFIX . "templatehistory WHERE templatehistoryid IN ($ids)");
	}

	define('CP_REDIRECT', 'apm_template.php?do=history&amp;dostyleid=' . $vbulletin->GPC['dostyleid'] . '&amp;title=' . urlencode($vbulletin->GPC['title']) . "&amp;showtemplates=" . $vbulletin->GPC['showtemplates']);
	print_stop_message('template_history_entries_deleted');
}

// #############################################################################
// generate a diff between two templates (current or historical versions)
if ($_POST['do'] == 'docompare')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'left_template' => TYPE_STR,
		'right_template' => TYPE_STR,
		'switch_wrapping' => TYPE_NOHTML,
		'switch_inline' => TYPE_NOHTML,
		'wrap' => TYPE_BOOL,
		'inline' => TYPE_BOOL,
		'context_lines' => TYPE_UINT
	));

	$wrap = ($vbulletin->GPC_exists['switch_wrapping'] ? !$vbulletin->GPC['wrap'] : $vbulletin->GPC['wrap']);
	$inline = ($vbulletin->GPC_exists['switch_inline'] ? !$vbulletin->GPC['inline'] : $vbulletin->GPC['inline']);
	$context_lines = ($vbulletin->GPC_exists['context_lines'] ? $vbulletin->GPC['context_lines'] : 3);

	list($left_id, $left_type) = explode('|', $vbulletin->GPC['left_template']);
	list($right_id, $right_type) = explode('|', $vbulletin->GPC['right_template']);

	$left_template = fetch_template_current_historical($left_id, $left_type);
	$right_template = fetch_template_current_historical($right_id, $right_type);

	if (!$left_template OR !$right_template)
	{
		exit;
	}

	require_once(DIR . '/includes/class_diff.php');

	$diff = new vB_Text_Diff($left_template['templatetext'], $right_template['templatetext']);
	$entries =& $diff->fetch_diff();

	print_form_header('template', 'docompare', false, true, 'cpform', '90%', '', false, 'post', 0, true);
	print_table_header($vbphrase['display_options'], 1);
	?>
	<tr>
		<td colspan="4" class="tfoot" align="center">
			<input type="image" name="submit" src="<?php echo ('../' . $vbulletin->options['cleargifurl']); ?>" style="height:10px;width:10px" alt="<?php echo $vbphrase['update']; ?>" />
			<input type="submit" name="switch_inline" class="submit" value="<?php echo ($inline ? $vbphrase['view_side_by_side'] : $vbphrase['view_inline']); ?>" accesskey="r" />
			<input type="submit" name="switch_wrapping" class="submit" value="<?php echo ($wrap ? $vbphrase['disable_wrapping'] : $vbphrase['enable_wrapping']); ?>" accesskey="s" />
	<?php
	if ($inline)
	{
	?>
			&nbsp;&nbsp;&nbsp;&nbsp;
			<input type="text" name="context_lines" value="<?php echo $context_lines; ?>" size="2" class="ctrl_context_lines" dir="<?php echo vB_Template_Runtime::fetchStyleVar('textdirection'); ?>" accesskey="t" />
			<strong><?php echo $vbphrase['lines_around_each_diff']; ?></strong>
			&nbsp;&nbsp;&nbsp;&nbsp;
			<input type="submit" name="submit_diff" class="submit" value="<?php echo $vbphrase['update'] ?>" accesskey="u" />
	<?php
	}
	?>
		</td>
	</tr>
	<?php

	construct_hidden_code('left_template', $vbulletin->GPC['left_template']);
	construct_hidden_code('right_template', $vbulletin->GPC['right_template']);
	construct_hidden_code('wrap', $wrap);
	construct_hidden_code('inline', $inline);
	print_table_footer(1);

	print_table_start(true, '90%', '', '', true);
	print_table_header(construct_phrase($vbphrase['comparing_versions_of_x'], htmlspecialchars_uni($left_template['title'])), 4);

	if (!$inline)
	{
		// side by side
		print_cells_row(array(
			$vbphrase['old_version'],
			$vbphrase['new_version']
		), true, false, 1);

		foreach ($entries AS $diff_entry)
		{
			// possible classes: unchanged, notext, deleted, added, changed
			echo "<tr>\n\t";
			echo '<td width="50%" valign="top" class="diff-' . $diff_entry->fetch_data_old_class() . '" dir="ltr">';

			foreach ($diff_entry->fetch_data_old() AS $content)
			{
				echo $diff_entry->prep_diff_text($content, $wrap) . "<br />\n";
			}

			echo '</td><td width="50%" valign="top" class="diff-' . $diff_entry->fetch_data_new_class() . '" dir="ltr">';

			foreach ($diff_entry->fetch_data_new() AS $content)
			{
				echo $diff_entry->prep_diff_text($content, $wrap) . "\n";
			}

			echo "</td></tr>\n\n";
		}
	}
	else
	{
		// inline
		echo "	<tr valign=\"top\" align=\"center\">
					<td class=\"thead\">$vbphrase[old]</td>
					<td class=\"thead\">$vbphrase[new]</td>
					<td class=\"thead\" width=\"100%\">$vbphrase[content]</td>
				</tr>";

		$wrap_buffer = array();
		$first_diff = true;

		foreach ($entries AS $diff_entry)
		{
			if ('unchanged' == $diff_entry->old_class)
			{
				$old_data = $diff_entry->fetch_data_old();
				$new_data_keys = array_keys($diff_entry->fetch_data_new());

				if (sizeof($entries) <= 1)
				{
					$context_lines = sizeof($old_data);
				}

				if (!$context_lines)
				{
					continue;
				}

				// add unchanged lines to wrap buffer
				foreach ($diff_entry->fetch_data_old() AS $lineno => $content)
				{
					$wrap_buffer[] = array('oldline' => $lineno, 'newline' => array_shift($new_data_keys), 'content' => $content);
				}

				continue;
			}
			else if(sizeof($wrap_buffer))
			{
				if (sizeof($wrap_buffer) > $context_lines)
				{
					if (!$first_diff)
					{
						$buffer = array_slice($wrap_buffer, 0, $context_lines);
						$buffer[] = array('oldline' => '', 'newline' => '', 'content' => '<hr />');
						$wrap_buffer = array_merge($buffer, array_slice($wrap_buffer, -$context_lines));
					}
					else
					{
						$wrap_buffer = array_slice($wrap_buffer, -$context_lines);
						$first_diff = false;
					}
				}

				foreach ($wrap_buffer AS $wrap_line)
				{
					if (!$wrap_line['oldline'] AND !$wrap_line['newline'])
					{
						echo '<tr><td class="diff-linenumber">...</td><td class="diff-linenumber">...</td>';
						echo '<td colspan="2" class="diff-unchanged diff-inline-break"></td></tr>';
					}
					else
					{
						echo "<tr>\n\t<td class=\"diff-linenumber\">$wrap_line[oldline]</td><td class=\"diff-linenumber\">$wrap_line[newline]</td>";
						echo '<td colspan="2" valign="top" class="diff-unchanged" dir="ltr">';
						echo $diff_entry->prep_diff_text($wrap_line['content'], $wrap);
						echo "</td></tr>\n\n";
					}
				}

				$wrap_buffer = array();
			}

			$data_old = $diff_entry->fetch_data_old();
			$data_new = $diff_entry->fetch_data_new();
			$data_old_len = sizeof($data_old);
			$data_new_len = sizeof($data_new);

			$first = true;
			$current = 1;

			foreach ($data_old AS $lineno => $content)
			{
				$class = 'diff-deleted';

				// only top border the first line
				$class .= ($first ? ' diff-inline-deleted-start' : '');

				// only bottom border the last line if it is not followed by a new diff
				$class .= ($current >= $data_old_len ? ($data_new_len ? '' : ' diff-inline-deleted-end') : '');

				echo "<tr>\n\t<td class=\"diff-linenumber\">$lineno</td><td class=\"diff-linenumber\">&nbsp;</td>";
				echo '<td colspan="" valign="top" class="' . $class . '" dir="ltr">';
				echo $diff_entry->prep_diff_text($content, $wrap);
				echo "</td></tr>\n\n";

				$first = false;
				$current++;
			}

			$first = true;
			$current = 1;

			foreach ($data_new AS $lineno => $content)
			{
				$class = 'diff-inline-added';

				// only top border the first line if it doesn't consecutively follow an old diff comparison
				$class .= ($first ? ($data_old_len ? '' : ' diff-inline-added-start') : '');

				// only bottom border the last line
				$class .= ($current >= $data_new_len ? ' diff-inline-added-end' : '');

				echo "<tr>\n\t<td class=\"diff-linenumber\">&nbsp;</td><td class=\"diff-linenumber\">$lineno</td>";
				echo '<td colspan="" valign="top" class="' . $class . '" dir="ltr">';
				echo $diff_entry->prep_diff_text($content, $wrap);
				echo "</td></tr>\n\n";

				$first = false;
				$current++;
			}
		}

		// If any buffer remains display the first two lines
		if (sizeof($wrap_buffer))
		{
			$i = 0;
			while ($i < $context_lines AND ($wrap_line = array_shift($wrap_buffer)))
			{
				echo "<tr>\n\t<td class=\"diff-linenumber\">$wrap_line[oldline]</td><td class=\"diff-linenumber\">$wrap_line[newline]</td>";
				echo '<td colspan="2" valign="top" class="diff-unchanged" dir="ltr">';
				echo $diff_entry->prep_diff_text($wrap_line['content'], $wrap);
				echo "</td></tr>\n\n";

				$i++;
			}
		}
		unset($wrap_buffer);
	}

	print_table_footer();

	print_form_header('template', 'docompare', false, true, 'cpform2', '90%', '', true, 'post', 0, true);
	print_table_header($vbphrase['display_options'], 1);
	?>
	<tr>
		<td colspan="4" class="tfoot" align="center">
			<input type="submit" name="switch_inline" class="submit" value="<?php echo ($inline ? $vbphrase['view_side_by_side'] : $vbphrase['view_inline']); ?>" accesskey="r" />
			<input type="submit" name="switch_wrapping" class="submit" value="<?php echo ($wrap ? $vbphrase['disable_wrapping'] : $vbphrase['enable_wrapping']); ?>" accesskey="s" />
	<?php
	if ($inline)
	{
	?>
			&nbsp;&nbsp;&nbsp;&nbsp;
			<input type="text" name="context_lines" value="<?php echo $context_lines; ?>" size="2" class="ctrl_context_lines" dir="<?php echo vB_Template_Runtime::fetchStyleVar('textdirection'); ?>" accesskey="t" />
			<strong><?php echo $vbphrase['lines_around_each_diff']; ?></strong>
			&nbsp;&nbsp;&nbsp;&nbsp;
			<input type="submit" name="submit_diff" class="submit" value="<?php echo $vbphrase['update'] ?>" accesskey="u" />
	<?php
	}
	?>
		</td>
	</tr>
	<?php

	construct_hidden_code('left_template', $vbulletin->GPC['left_template']);
	construct_hidden_code('right_template', $vbulletin->GPC['right_template']);
	construct_hidden_code('wrap', $wrap);
	construct_hidden_code('inline', $inline);
	print_table_footer(1);

	print_form_header('', '');
	print_table_header($vbphrase['comparison_key']);

	if ($inline)
	{
		echo "<tr><td class=\"diff-deleted diff-inline-deleted-end\" align=\"center\">$vbphrase[text_in_old_version]</td></tr>\n";
		echo "<tr><td class=\"diff-added diff-inline-added-end\" align=\"center\">$vbphrase[text_in_new_version]</td></tr>\n";
		echo "<tr><td class=\"diff-unchanged\" align=\"center\">$vbphrase[text_surrounding_changes]</td></tr>\n";
	}
	else
	{
		echo "<tr><td class=\"diff-deleted\" align=\"center\" width=\"50%\">$vbphrase[text_removed_from_old_version]</td><td class=\"diff-notext\">&nbsp;</td></tr>\n";
		echo "<tr><td class=\"diff-changed\" colspan=\"2\" align=\"center\">$vbphrase[text_changed_between_versions]</td></tr>\n";
		echo "<tr><td class=\"diff-notext\" width=\"50%\">&nbsp;</td><td class=\"diff-added\" align=\"center\">$vbphrase[text_added_in_new_version]</td></tr>\n";
	}

	print_table_footer();
}

// #############################################################################
// generate a diff between two templates (current or historical versions)
if ($_REQUEST['do'] == 'docompare3')
{

	/*
		Copied from vB_Text_Diff_Entry::prep_diff_text
		I don't want to put html formatting code in the merge class, but I'm not
		sure this really belongs here either.
	*/

	function docompare3_print_control_form($inline, $wrap)
	{
		global $vbphrase, $vbulletin;

		$editlink = '?do=edit&amp;templateid=' . $vbulletin->GPC['templateid'] .
			'&amp;group=&amp;searchstring=&amp;expandset=5&amp;showmerge=1';

		print_form_header('template', 'docompare3', false, true, 'cpform', '90%', '', false);
		construct_hidden_code('templateid', $vbulletin->GPC['templateid']);
		construct_hidden_code('wrap', $wrap);
		construct_hidden_code('inline', $inline);

		print_table_header($vbphrase['display_options']);
		print_table_footer(2,
			'<div style="float:' . vB_Template_Runtime::fetchStyleVar('right') . '"><a href="' . $editlink . '" style="font-weight: bold">' . $vbphrase['merge_edit_link'] . '</a></div>
			<div align="' . vB_Template_Runtime::fetchStyleVar('left') . '"><input type="submit" name="switch_inline" class="submit" value="' . ($inline ? $vbphrase['view_side_by_side'] : $vbphrase['view_inline']) . '" accesskey="r" />
			<input type="submit" name="switch_wrapping" class="submit" value="' . ($wrap ? $vbphrase['disable_wrapping'] : $vbphrase['enable_wrapping']) . '" accesskey="s" /></div>'
		);
	}

	//get values
	$vbulletin->input->clean_array_gpc('r', array(
		'templateid' => TYPE_STR,
		'switch_wrapping' => TYPE_NOHTML,
		'switch_inline' => TYPE_NOTHTML,
		'inline' => TYPE_BOOL,
		'wrap' => TYPE_BOOL,
	));

	if ($vbulletin->GPC_exists['wrap'])
	{
		$wrap = ($vbulletin->GPC_exists['switch_wrapping'] ? !$vbulletin->GPC['wrap'] : $vbulletin->GPC['wrap']);
	}
	else
	{
		$wrap = true;
	}

	if ($vbulletin->GPC_exists['inline'])
	{
		$inline = ($vbulletin->GPC_exists['switch_inline'] ? !$vbulletin->GPC['inline'] : $vbulletin->GPC['inline']);
	}
	else
	{
		$inline = true;
	}

	$templateid = $vbulletin->GPC['templateid'];

	//find templates
	try
	{
		$templates = fetch_templates_for_merge($templateid);
		$new = $templates["new"];
		$custom = $templates["custom"];
		$origin = $templates["origin"];
	}
	catch (Exception $e)
	{
		print_cp_message($e->getMessage());
	}

	require_once (DIR . '/includes/class_merge.php');
	$merge = new vB_Text_Merge_Threeway($origin['template_un'], $new['template_un'], $custom['template_un']);
	$chunks = $merge->get_chunks();

	docompare3_print_control_form($inline, $wrap);

	print_table_start(true, '90%', 0, ($inline ? 'compare_inline' : 'compare_side'));
	print_table_header(
		construct_phrase($vbphrase['comparing_versions_of_x'], htmlspecialchars_uni($custom['title'])),
		$inline ? 1 : 3
	);

	if ($inline)
	{
		foreach ($chunks as $chunk)
		{
			if ($chunk->is_stable())
			{
				$formatted_text = format_diff_text($chunk->get_text_original(), $wrap);
				$class = "merge-nochange";
			}
			else
			{
				$text = $chunk->get_merged_text();
				if ($text === false)
				{
					$formatted_text = format_conflict_text(
						$chunk->get_text_right(), $chunk->get_text_original(), $chunk->get_text_left(),
						$origin['version'], $new['version'], true, $wrap
					);
					$class = "merge-conflict";
				}
				else
				{
					$formatted_text = format_diff_text($text, $wrap);
					$class = "merge-successful";
				}
			}
			echo "<tr>\n\t";
			echo "<td width='100%' valign='top' class='$class' dir='ltr'>\n";
			echo $formatted_text;
			echo "\n</td>\n</tr>\n\n";
		}
	}
	else
	{
		$cells = array(
			$vbphrase['your_customized_template'],
			$vbphrase['merged_template_conflicts_show_original'],
			$vbphrase['new_default_template']
		);
		print_cells_row($cells, true, false, 1);

		foreach ($chunks as $chunk)
		{
			if ($chunk->is_stable())
			{
				$col1 = $chunk->get_text_original();
				$col2 = $col1;
				$col3 = $col1;
				$class = "merge-nochange";
			}
			else
			{
				$col1 = $chunk->get_text_right();
				$col2 = $chunk->get_merged_text();
				if ($col2 === false) {
					$class = "merge-conflict";
					$col2 = $chunk->get_text_original();
				}
				else
				{
					$class = "merge-successful";
				}

				$col3 = $chunk->get_text_left();
			}

			// possible classes: unchanged, notext, deleted, added, changed
			echo "<tr>\n\t";
			echo '<td width="33%" valign="top" class="' . $class . '" dir="ltr">';
			echo	format_diff_text($col1, $wrap);
			echo '</td><td width="34%" valign="top" class="' . $class . '" dir="ltr">';
			echo	format_diff_text($col2, $wrap);
			echo '</td><td width="33%" valign="top" class="' . $class . '" dir="ltr">';
			echo	format_diff_text($col3, $wrap);
			echo "</td></tr>\n\n";
		}
	}
	print_table_footer();

	echo '<br />';
	docompare3_print_control_form($inline, $wrap);

	print_form_header('', '');
	print_table_header($vbphrase['comparison_key']);

	$conflictkey = "";
	echo '<tr><td class="merge-conflict" align="center">' . $vbphrase['merge_key_conflict'] .
		$conflictkey . "</td></tr>\n";
	echo '<tr><td class="merge-successful" align="center">' . $vbphrase['merge_key_merged'] . "</td></tr>\n";
	echo '<tr><td class="merge-nochange" align="center">' . $vbphrase['merge_key_none'] . "</td></tr>\n";

	print_table_footer();
}

// #############################################################################
// insert queries and cache rebuilt for template insertion
if ($_POST['do'] == 'inserttemplate')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'title'          => TYPE_STR,
		'product'        => TYPE_STR,
		'template'       => TYPE_NOTRIM,
		'searchstring'   => TYPE_STR,
		'expandset'      => TYPE_NOHTML,
		'searchset'      => TYPE_NOHTML,
		'savehistory'    => TYPE_BOOL,
		'histcomment'    => TYPE_STR,
		'return'         => TYPE_STR,
		'group'          => TYPE_STR,
		'confirmremoval' => TYPE_BOOL,
		'confirmerrors'  => TYPE_BOOL,
		'showtemplates'  => TYPE_UINT,
	));

	// remove escaped CDATA (just in case user is pasting template direct from an XML editor
	// where the CDATA tags will have been escaped by our escaper...
	//$template = xml_unescape_cdata($template);

	if (!$vbulletin->GPC['title'])
	{
		print_stop_message('please_complete_required_fields');
	}

	if ($vbulletin->GPC['title'] == 'footer' AND !$vbulletin->GPC['confirmremoval'])
	{
		if (strpos($vbulletin->GPC['template'], '$vbphrase[powered_by_vbulletin]') === false)
		{
			print_form_header('apm_template', 'inserttemplate', 0, 1, '', '75%');
			construct_hidden_code('confirmremoval', 1);
			construct_hidden_code('title', $vbulletin->GPC['title']);
			construct_hidden_code('template', $vbulletin->GPC['template']);
			construct_hidden_code('group', $vbulletin->GPC['group']);
			construct_hidden_code('searchstring', $vbulletin->GPC['searchstring']);
			construct_hidden_code('dostyleid', $vbulletin->GPC['dostyleid']);
			construct_hidden_code('savehistory', intval($vbulletin->GPC['savehistory']));
			construct_hidden_code('histcomment', $vbulletin->GPC['histcomment']);
			construct_hidden_code('product', $vbulletin->GPC['product']);
			construct_hidden_code('showtemplates', $vbulletin->GPC['showtemplates']);
			print_table_header($vbphrase['confirm_removal_of_copyright_notice']);
			print_description_row($vbphrase['it_appears_you_are_removing_vbulletin_copyright']);
			print_submit_row($vbphrase['yes'], 0, 2, $vbphrase['no']);
			print_cp_footer();
			exit;
		}
	}

	$get_existing = $db->query_read("
		SELECT templateid, styleid, product FROM " . TABLE_PREFIX . "template
		WHERE title = '" . $db->escape_string($vbulletin->GPC['title']) . "'
		AND templatetype = 'template'
	");
	$exists = array();
	while ($curtemplate = $db->fetch_array($get_existing))
	{
		$exists["$curtemplate[styleid]"] = $curtemplate;
	}
	$db->free_result($get_existing);

	$template_un = $vbulletin->GPC['template'];
	$vbulletin->GPC['template'] = compile_template($vbulletin->GPC['template']);

	// work out what we should be doing with the product field
	if ($exists['-1'] AND $vbulletin->GPC['dostyleid'] != -1)
	{
		// there is already a template with this name in the master set - don't allow a different product id
		$vbulletin->GPC['product'] = $exists['-1']['product'];
	}
	else if ($vbulletin->GPC['dostyleid'] != -1)
	{
		// we are not adding a new template to the master set - only allow the default product id
		$vbulletin->GPC['product'] = 'vbulletin';
	}
	else
	{
		// allow this - we are adding a totally new template to the master set
	}

	// error checking on conditionals
	if (empty($vbulletin->GPC['confirmerrors']))
	{
		$errors = check_template_errors($vbulletin->GPC['template']);

		if (!empty($errors))
		{
			print_form_header('apm_template', 'inserttemplate', 0, 1, '', '75%');
			construct_hidden_code('confirmerrors', 1);
			construct_hidden_code('title', $vbulletin->GPC['title']);
			construct_hidden_code('template', $template_un);
			construct_hidden_code('templateid', $vbulletin->GPC['templateid']);
			construct_hidden_code('group', $vbulletin->GPC['group']);
			construct_hidden_code('searchstring', $vbulletin->GPC['searchstring']);
			construct_hidden_code('dostyleid', $vbulletin->GPC['dostyleid']);
			construct_hidden_code('savehistory', intval($vbulletin->GPC['savehistory']));
			construct_hidden_code('histcomment', $vbulletin->GPC['histcomment']);
			construct_hidden_code('product', $vbulletin->GPC['product']);
			construct_hidden_code('showtemplates', $vbulletin->GPC['showtemplates']);
			print_table_header($vbphrase['vbulletin_message']);
			print_description_row(construct_phrase($vbphrase['template_eval_error'], $errors));
			print_submit_row($vbphrase['continue'], 0, 2, $vbphrase['go_back']);
			print_cp_footer();
			exit;
		}
	}

	// check if template already exists
	if (!$exists[$vbulletin->GPC['dostyleid']])
	{
		/*insert query*/
		$result = $db->query_write("
			INSERT INTO " . TABLE_PREFIX . "template
				(styleid, title, template, template_un, dateline, username, version, product)
			VALUES
				(" . $vbulletin->GPC['dostyleid'] . ",
				'" . $db->escape_string($vbulletin->GPC['title']) . "',
				'" . $db->escape_string($vbulletin->GPC['template']) . "',
				'" . $db->escape_string($template_un) . "',
				" . TIMENOW . ",
				'" . $db->escape_string($vbulletin->userinfo['username']) . "',
				'" . $db->escape_string($full_product_info[$vbulletin->GPC['product']]['version']) . "',
				'" . $db->escape_string($vbulletin->GPC['product']) . "')
		");
		$vbulletin->GPC['templateid'] = $db->insert_id($result);
		// now to update the template id list for this style and all its dependents...
		print_rebuild_style($vbulletin->GPC['dostyleid'], '', 0, 0, 0, 0);

		if (strpos($vbulletin->GPC['title'], 'bbcode_') === 0)
		{
			// begins with bbcode_ - empty the post parsed cache
			$vbulletin->db->query_write("TRUNCATE TABLE " . TABLE_PREFIX . "postparsed");
		}
	}
	else
	{
		print_form_header('apm_template', 'updatetemplate', 0, 1, '', '75%');
		construct_hidden_code('confirmerrors', 1);
		construct_hidden_code('title', $vbulletin->GPC['title']);
		construct_hidden_code('oldtitle', $vbulletin->GPC['title']);
		construct_hidden_code('template', $template_un);
		construct_hidden_code('return', $vbulletin->GPC['return']);
		construct_hidden_code('templateid', $exists[$vbulletin->GPC['dostyleid']]['templateid']);
		construct_hidden_code('group', $vbulletin->GPC['group']);
		construct_hidden_code('searchstring', $vbulletin->GPC['searchstring']);
		construct_hidden_code('dostyleid', $vbulletin->GPC['dostyleid']);
		construct_hidden_code('savehistory', intval($vbulletin->GPC['savehistory']));
		construct_hidden_code('histcomment', $vbulletin->GPC['histcomment']);
		construct_hidden_code('product', $vbulletin->GPC['product']);
		construct_hidden_code('showtemplates', $vbulletin->GPC['showtemplates']);
		print_table_header($vbphrase['vbulletin_message']);
		print_description_row(construct_phrase($vbphrase['template_x_exists_error'], $vbulletin->GPC['title']));
		print_submit_row($vbphrase['save'], 0, 2, $vbphrase['go_back']);
		print_cp_footer();
		exit;
	}

	if ($vbulletin->GPC['savehistory'])
	{
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "templatehistory
				(styleid, title, template, dateline, username, version, comment)
			VALUES
				(" . $vbulletin->GPC['dostyleid'] . ",
				'" . $db->escape_string($vbulletin->GPC['title']) . "',
				'" . $db->escape_string($template_un) . "',
				" . TIMENOW . ",
				'" . $db->escape_string($vbulletin->userinfo['username']) . "',
				'" . $db->escape_string($full_product_info[$vbulletin->GPC['product']]['version']) . "',
				'" . $db->escape_string($vbulletin->GPC['histcomment']) . "')
		");
	}

	if ($vbulletin->GPC['return'])
	{
		$goto = 'apm_template.php?' . $vbulletin->session->vars['sessionurl'] . "do=edit&amp;expandset=" . $vbulletin->GPC['expandset'] . "&amp;searchset=" . $vbulletin->GPC['searchset'] . "&amp;group=" . $vbulletin->GPC['group'] . "&amp;templateid=" . $vbulletin->GPC['templateid'] . "&amp;searchstring=" . urlencode($vbulletin->GPC['searchstring']) . "&amp;showtemplates=" . $vbulletin->GPC['showtemplates'];
	}
	else
	{
		$goto = "apm_product.php?do=managedetails&amp;productid=" . $vbulletin->GPC['product'] . "&amp;showtemplates=" . $vbulletin->GPC['showtemplates'];
	}

	print_cp_redirect($goto, 1);
}

// #############################################################################
// add a new template form
if ($_REQUEST['do'] == 'add')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'productid' => TYPE_STR,
		'title' => TYPE_STR,
		'group' => TYPE_STR,
		'searchstring' => TYPE_STR,
		'expandset' => TYPE_STR,
		'showtemplates'	=> TYPE_UINT,
	));

	if ($vbulletin->GPC['dostyleid'] == -1)
	{
		$style['title'] = $vbphrase['global_templates'];
	}
	else
	{
		$style = $db->query_first("SELECT title FROM " . TABLE_PREFIX . "style WHERE styleid = " . $vbulletin->GPC['dostyleid']);
	}

	if ($vbulletin->GPC['title'])
	{
		$templateinfo = $db->query_first("
			SELECT * FROM " . TABLE_PREFIX . "template
			WHERE styleid IN (-1,0) AND title = '" . $db->escape_string($vbulletin->GPC['title']) . "'
		");
	}
	else if ($vbulletin->GPC['templateid'])
	{
		$templateinfo = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "template WHERE templateid = " . $vbulletin->GPC['templateid']);
		$vbulletin->GPC['title'] = $templateinfo['title'];
	}
	else
	{
		$templateinfo['product'] = $vbulletin->GPC['productid'];
	}

	print_form_header('apm_template', 'inserttemplate');
	print_table_header(iif($vbulletin->GPC['title'],
		construct_phrase($vbphrase['customize_template_x'], $vbulletin->GPC['title']),
		$vbphrase['add_new_template']
	));

	construct_hidden_code('group', $vbulletin->GPC['group']);
	construct_hidden_code('showtemplates', $vbulletin->GPC['showtemplates']);

	$products = fetch_product_list();

	if ($vbulletin->GPC['title'])
	{
		construct_hidden_code('product', $templateinfo['product']);
		print_label_row($vbphrase['product'], $products["$templateinfo[product]"]);
	}
	else
//	else if ($vbulletin->debug)
	{
		print_select_row($vbphrase['product'], 'product', $products, $templateinfo['product']);
	}
//	else
//	{ // use the default as we dictate in inserttemplate, if they dont have debug mode on they can't add templates to -1 anyway
//		construct_hidden_code('product', 'vbulletin');
//	}
	construct_hidden_code('productid', $vbulletin->GPC['productid']);

	if ($vbulletin->GPC['dostyleid'] > 0)
	{
		$history = $db->query_first("
			SELECT title
			FROM " . TABLE_PREFIX . "templatehistory
			WHERE title = '" . $db->escape_string($vbulletin->GPC['title']) . "'
				AND styleid = " . $vbulletin->GPC['dostyleid']
		);
	}
	else
	{
		$history = null;
	}

	construct_hidden_code('expandset', $vbulletin->GPC['expandset']);
	construct_hidden_code('searchset', $vbulletin->GPC['expandset']);
	construct_hidden_code('searchstring', $vbulletin->GPC['searchstring']);
	print_style_chooser_row('dostyleid', $vbulletin->GPC['dostyleid'], $vbphrase['master_style'], $vbphrase['style'], iif($vbulletin->debug == 1, 1, 0));
	print_input_row(
		$vbphrase['title'] .
			($history ?
				'<dfn>' .
				construct_link_code($vbphrase['view_history'], 'apm_template.php?do=history&amp;dostyleid=' . $vbulletin->GPC['dostyleid'] . '&amp;title=' . urlencode($vbulletin->GPC['title']), 1) .
				'</dfn>'
			: ''),
		'title',
		$vbulletin->GPC['title']);
	print_textarea_row($vbphrase['template'] . '
			<br /><br />
			<span class="smallfont">' .
			iif($vbulletin->GPC['title'], construct_link_code($vbphrase['show_default'], "apm_template.php?" . $vbulletin->session->vars['sessionurl'] . "do=view&amp;title=" . $vbulletin->GPC['title'], 1) . '<br /><br />', '') .
			'<!--' . $vbphrase['wrap_text'] . '<input type="checkbox" unselectable="on" onclick="set_wordwrap(\'ta_template\', this.checked);" accesskey="w" checked="checked" />-->
			</span>',
		'template', $templateinfo['template_un'], 22, '75" style="width:100%', true, true, 'ltr', 'code');
	print_template_javascript();
	print_label_row($vbphrase['save_in_template_history'], '<label for="savehistory"><input type="checkbox" name="savehistory" id="savehistory" value="1" tabindex="1" />' . $vbphrase['yes'] . '</label><br /><span class="smallfont">' . $vbphrase['comment'] . '</span> <input type="text" name="histcomment" value="" tabindex="1" class="bginput" size="50" />');
	print_submit_row($vbphrase['save'], '_default_', 2, '', "<input type=\"submit\" class=\"button\" tabindex=\"1\" name=\"return\" value=\"$vbphrase[save_and_reload]\" accesskey=\"e\" />");
	?>
	<script type="text/javascript">
	<!--
	var initial_crc32 = crc32(YAHOO.util.Dom.get(textarea_id).value);
	var confirmUnload = true;
	YAHOO.util.Event.addListener('cpform', 'submit', function(e) { confirmUnload = false; });
	YAHOO.util.Event.addListener(window, 'beforeunload', function(e) {
		if (initial_crc32 != crc32(YAHOO.util.Dom.get(textarea_id).value) && confirmUnload) {
			e.returnValue = '<?php echo addslashes_js($vbphrase[unsaved_data_may_be_lost]); ?>';
		}
	});
	//-->
	</script>
	<?php
}

// #############################################################################
// simple update query for an existing template
if ($_POST['do'] == 'updatetemplate')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'title'         => TYPE_STR,
		'oldtitle'      => TYPE_STR,
		'template'      => TYPE_NOTRIM,
		'group'         => TYPE_STR,
		'product'       => TYPE_STR,
		'savehistory'   => TYPE_BOOL,
		'histcomment'   => TYPE_STR,
		'string'        => TYPE_STR,
		'searchstring'  => TYPE_STR,
		'expandset'     => TYPE_NOHTML,
		'searchset'     => TYPE_NOHTML,
		'return'        => TYPE_STR,
		'confirmerrors' => TYPE_BOOL,
		'lastedit'      => TYPE_UINT,
		'showtemplates' => TYPE_UINT,
	));

	function updatetemplate_print_error_page($template_un, $error)
	{
		global $vbulletin, $vbphrase;
		print_form_header('template', 'updatetemplate', 0, 1, '', '75%');
		construct_hidden_code('confirmerrors', 1);
		construct_hidden_code('title', $vbulletin->GPC['title']);
		construct_hidden_code('template', $template_un);
		construct_hidden_code('templateid', $vbulletin->GPC['templateid']);
		construct_hidden_code('group', $vbulletin->GPC['group']);
		construct_hidden_code('searchstring', $vbulletin->GPC['searchstring']);
		construct_hidden_code('dostyleid', $vbulletin->GPC['dostyleid']);
		construct_hidden_code('product', $vbulletin->GPC['product']);
		construct_hidden_code('savehistory', intval($vbulletin->GPC['savehistory']));
		construct_hidden_code('histcomment', $vbulletin->GPC['histcomment']);
			construct_hidden_code('showtemplates', $vbulletin->GPC['showtemplates']);
		print_table_header($vbphrase['vbulletin_message']);
		print_description_row($error);
		print_submit_row($vbphrase['continue'], 0, 2, $vbphrase['go_back']);
		print_cp_footer();
	}


	// remove escaped CDATA (just in case user is pasting template direct from an XML editor
	// where the CDATA tags will have been escaped by our escaper...
	// $template = xml_unescape_cdata($template);

	$template_un = $vbulletin->GPC['template'];
	$vbulletin->GPC['template'] = compile_template($vbulletin->GPC['template']);

	// error checking on conditionals
	if (empty($vbulletin->GPC['confirmerrors']))
	{
		$errors = check_template_errors($vbulletin->GPC['template']);
		if (!empty($errors))
		{
			updatetemplate_print_error_page($template_un, construct_phrase($vbphrase['template_eval_error'], $errors));
			exit;
		}

		$errors = check_template_conflict_error($vbulletin->GPC['template']);
		if ($errors)
		{
			updatetemplate_print_error_page($template_un, $errors);
			exit;
		}
	}

	$old_template = $db->query_first("
		SELECT title, styleid, dateline, username, template_un
		FROM " . TABLE_PREFIX . "template
		WHERE templateid = " . $vbulletin->GPC['templateid'] . "
	");
	 if (strtolower($vbulletin->GPC['title']) != strtolower($old_template['title']) AND $db->query_first("
		SELECT templateid
		FROM " . TABLE_PREFIX . "template
		WHERE styleid = $old_template[styleid] AND title = '" . $db->escape_string($vbulletin->GPC['title']) . "'
	"))
	{
		print_stop_message('template_x_exists', $vbulletin->GPC['title']);
	}

	if ($vbulletin->GPC['lastedit'] AND $vbulletin->GPC['lastedit'] != $old_template['dateline'])
	{
		$comment = construct_phrase($vbphrase['template_edited_after_load'], $old_template['username']);
		echo "<p align=\"center\"><strong>$comment</strong></p>";
		/* Save what was in the template into the history */
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "templatehistory
				(styleid, title, template, dateline, username, version, comment)
			VALUES
				($old_template[styleid],
				'" . $db->escape_string($vbulletin->GPC['title']) . "',
				'" . $db->escape_string($old_template['template_un']) . "',
				" . TIMENOW . ",
				'" . $db->escape_string($vbulletin->userinfo['username']) . "',
				'" . $db->escape_string($full_product_info[$vbulletin->GPC['product']]['version']) . "',
				'" . $db->escape_string($comment) . "'
		)");
	}

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "template SET
			title = '" . $db->escape_string($vbulletin->GPC['title']) . "',
			template = '" . $db->escape_string($vbulletin->GPC['template']) . "',
			template_un = '" . $db->escape_string($template_un) . "',
			dateline = " . TIMENOW . ",
			username = '" . $db->escape_string($vbulletin->userinfo['username']) . "',
			version = '" . $db->escape_string($full_product_info[$vbulletin->GPC['product']]['version']) . "',
			product = '" . $db->escape_string($vbulletin->GPC['product']) . "',
			mergestatus = 'none'
		WHERE templateid = " . $vbulletin->GPC['templateid'] . "
	");

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "templatemerge
		WHERE templateid = " . $vbulletin->GPC['templateid']
	);

	if (strpos($vbulletin->GPC['title'], 'bbcode_') === 0)
	{
		// begins with bbcode_ - empty the post parsed cache
		$vbulletin->db->query_write("TRUNCATE TABLE " . TABLE_PREFIX . "postparsed");
	}

	// update any customized templates to reflect a change of product id
	if ($old_template['styleid'] == -1 AND $vbulletin->GPC['product'] != $old_template['product'])
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "template
			SET product = '" . $db->escape_string($vbulletin->GPC['product']) . "'
			WHERE title = '" . $db->escape_string($vbulletin->GPC['title']) . "'
				AND styleid <> -1
		");
	}

	if ($vbulletin->GPC['savehistory'])
	{
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "templatehistory
				(styleid, title, template, dateline, username, version, comment)
			VALUES
				($old_template[styleid],
				'" . $db->escape_string($vbulletin->GPC['title']) . "',
				'" . $db->escape_string($template_un) . "',
				" . TIMENOW . ",
				'" . $db->escape_string($vbulletin->userinfo['username']) . "',
				'" . $db->escape_string($full_product_info[$vbulletin->GPC['product']]['version']) . "',
				'" . $db->escape_string($vbulletin->GPC['histcomment']) . "')
		");
	}

	//we need to rebuild the style if a css template is changed, we may need to
	//republish.
	if (preg_match('#\.css$#i', $vbulletin->GPC['title']))
	{
		print_rebuild_style($vbulletin->GPC['dostyleid'], '', 0, 0, 0, 0);
	}

	if ($vbulletin->GPC['return'])
	{
		$goto = "apm_template.php?do=edit&amp;templateid=" . $vbulletin->GPC['templateid'] . "&amp;group=" . $vbulletin->GPC['group'] . "&amp;expandset=" . $vbulletin->GPC['expandset'] . "&amp;searchset=" . $vbulletin->GPC['searchset'] . "&amp;searchstring=" . urlencode($vbulletin->GPC['searchstring']) . "&amp;showtemplates=" . $vbulletin->GPC['showtemplates'];
	}
	else
	{
		$goto = "apm_product.php?do=managedetails&amp;productid=" . $vbulletin->GPC['product'] . "&amp;showtemplates=" . $vbulletin->GPC['showtemplates'];
	}

	if ($vbulletin->GPC['title'] == $vbulletin->GPC['oldtitle'])
	{
		if ($vbulletin->GPC['return'])
		{
			print_cp_redirect($goto);
		}
		else
		{
			$_REQUEST['do'] = 'modify';
			$vbulletin->GPC['expandset'] = $vbulletin->GPC['dostyleid'];
		}

		$vbulletin->GPC['searchstring'] = $string ? $string : $vbulletin->GPC['searchstring'];
		$vbulletin->GPC['searchset'] = $vbulletin->GPC['dostyleid'];

		define('CP_REDIRECT', $goto);
		print_stop_message('saved_template_x_successfully', $vbulletin->GPC['title']);
	}
	else
	{
		print_rebuild_style($vbulletin->GPC['dostyleid'], '', 0, 0, 0, 0);
		print_cp_redirect($goto, 1);
	}
}

// #############################################################################
// edit form for an existing template
if ($_REQUEST['do'] == 'edit')
{

	function edit_get_merged_text($templateid)
	{
		global $vbphrase;

		$templates = fetch_templates_for_merge($templateid);
		$new = $templates["new"];
		$custom = $templates["custom"];
		$origin = $templates["origin"];

		require_once (DIR . '/includes/class_merge.php');
		$merge = new vB_Text_Merge_Threeway($origin['template_un'], $new['template_un'], $custom['template_un']);
		$chunks = $merge->get_chunks();

		$text = "";
		foreach ($chunks as $chunk)
		{
			if ($chunk->is_stable())
			{
				$text .= $chunk->get_text_original();
			}
			else
			{
				$chunk_text = $chunk->get_merged_text();
				if ($chunk_text === false)
				{
						$new_title = construct_phrase($vbphrase['merge_title_new'], $new['version']);
						$chunk_text = format_conflict_text($chunk->get_text_right(), $chunk->get_text_original(),
							 $chunk->get_text_left(), $origin['version'], $new['version']);
				}
				$text .= $chunk_text;
			}
		}
		return $text;
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'productid'	=> TYPE_STR,
		'group'		=> TYPE_STR,
		'searchstring'	=> TYPE_STR,
		'expandset'	=> TYPE_STR,
		'showtemplates'	=> TYPE_UINT,
		'showmerge' 	=> TYPE_BOOL
	));

	$template = $db->query_first("
		SELECT template.*, style.title AS style, IF(template.styleid = 0, -1, template.styleid) AS styleid
		FROM " . TABLE_PREFIX . "template AS template
		LEFT JOIN " . TABLE_PREFIX . "style AS style USING(styleid)
		WHERE templateid = " . $vbulletin->GPC['templateid'] . "
	");
	if ($template['styleid'] == -1)
	{
		$template['style'] = $vbphrase['master_style'];
	}

	if ($vbulletin->GPC['showmerge'])
	{
		try
		{
			$text = edit_get_merged_text($vbulletin->GPC['templateid']);
		}
		catch (Exception $e)
		{
			print_cp_message($e->getMessage());
		}

		print_table_start();
		print_description_row(
			construct_phrase($vbphrase['edting_merged_version_view_highlighted'], "apm_template.php?do=docompare3&amp;templateid=$template[templateid]")
		);
		print_table_footer();
	}
	else
	{
		if ($template['mergestatus'] == 'conflicted')
		{
			print_table_start();
			print_description_row(
				construct_phrase($vbphrase['default_version_newer_merging_failed'],
					"apm_template.php?do=docompare3&amp;templateid=$template[templateid]",
					$vbulletin->scriptpath . '&amp;showmerge=1'
				)
			);
			print_table_footer();
		}
		else if ($template['mergestatus'] == 'merged')
		{
			$merge_info = $db->query_first("
				SELECT *
				FROM " . TABLE_PREFIX . "templatemerge
				WHERE templateid = $template[templateid]
			");

			print_table_start();
			print_description_row(
				construct_phrase($vbphrase['changes_made_default_merged_customized'],
					"apm_template.php?do=docompare3&amp;templateid=$template[templateid]",
					"apm_template.php?do=viewversion&amp;id=$merge_info[savedtemplateid]&amp;type=historical"
				)
			);
			print_table_footer();
		}

		$text = $template['template_un'];
	}
	print_form_header('apm_template', 'updatetemplate');
	print_table_header(construct_phrase($vbphrase['x_y_id_z'], $vbphrase['template'], $template['title'], $template['templateid']));
	construct_hidden_code('templateid', $template['templateid']);
	construct_hidden_code('group', $vbulletin->GPC['group']);
	construct_hidden_code('searchstring', $vbulletin->GPC['searchstring']);
	construct_hidden_code('dostyleid', $template['styleid']);
	construct_hidden_code('expandset', $vbulletin->GPC['expandset']);
	construct_hidden_code('oldtitle', $template['title']);
	construct_hidden_code('lastedit', $template['dateline']);
	construct_hidden_code('showtemplates', $vbulletin->GPC['showtemplates']);
	$backlink = "apm_template.php?" . $vbulletin->session->vars['sessionurl'] . "do=modify&amp;expandset=$template[styleid]&amp;group=" . $vbulletin->GPC['group'] . "&amp;templateid=" . $vbulletin->GPC['templateid'] . "&amp;searchstring=" . urlencode($vbulletin->GPC['searchstring']) . "&amp;showtemplates=" . $vbulletin->GPC['showtemplates'];

	$products = fetch_product_list();

	if ($template['styleid'] == -1)
	{
		print_select_row($vbphrase['product'], 'product', $products, $template['product']);
	}
	else
	{
		print_label_row($vbphrase['product'], $products[($template['product'] ? $template['product'] : 'vbulletin')]);
		construct_hidden_code('product', ($template['product'] ? $template['product'] : 'vbulletin'));
	}
	print_label_row($vbphrase['style'], "<a href=\"$backlink\" title=\"" . $vbphrase['edit_templates'] . "\"><b>$template[style]</b></a>");
	print_input_row(
		$vbphrase['title'] . ($template['styleid'] != -1 ? '<dfn>' .
			construct_link_code($vbphrase['view_history'], 'apm_template.php?do=history&amp;dostyleid=' . $template['styleid'] . '&amp;title=' . urlencode($template['title']), 1) .
			'</dfn>' : ''),
		'title',
		$template['title']
	);

	print_textarea_row($vbphrase['template'] . '
			<br /><br />
			<span class="smallfont">' .
			iif($template['styleid'] != -1, construct_link_code($vbphrase['show_default'], "apm_template.php?" . $vbulletin->session->vars['sessionurl'] . "do=view&amp;title=$template[title]", 1) . '<br /><br />', '') .
			'<!--' . $vbphrase['wrap_text'] . '<input type="checkbox" unselectable="on" onclick="set_wordwrap(\'ta_template\', this.checked);" accesskey="w" checked="checked" />-->
			</span>',
		'template', $text, 22, '75" style="width:100%', true, true, 'ltr', 'code');

	print_template_javascript();

	print_label_row($vbphrase['save_in_template_history'],
		'<label for="savehistory"><input type="checkbox" name="savehistory" id="savehistory" value="1" tabindex="1" />' .
			$vbphrase['yes'] . '</label><br /><span class="smallfont">' . $vbphrase['comment'] .
			'</span> <input type="text" name="histcomment" value="" tabindex="1" class="bginput" size="50" />');

	print_submit_row($vbphrase['save'], '_default_', 2, '',
		"<input type=\"submit\" class=\"button\" tabindex=\"1\" name=\"return\" value=\"$vbphrase[save_and_reload]\" accesskey=\"e\" />");



?>
	<script type="text/javascript">
	<!--
	var initial_crc32 = crc32(YAHOO.util.Dom.get(textarea_id).value);
	var confirmUnload = true;
	YAHOO.util.Event.addListener('cpform', 'submit', function(e) { confirmUnload = false; });
	YAHOO.util.Event.addListener(window, 'beforeunload', function(e) {
		if (initial_crc32 != crc32(YAHOO.util.Dom.get(textarea_id).value) && confirmUnload) {
			e.returnValue = '<?php echo addslashes_js($vbphrase[unsaved_data_may_be_lost]); ?>';
		}
	});
	//-->
	</script>
	<?php
}

// #############################################################################
// kill a template and update template id caches for dependent styles
if ($_POST['do'] == 'kill')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'group' => TYPE_STR,
		'productid' => TYPE_STR,
		'showtemplates' => TYPE_UINT,
	));

	$template = $db->query_first("SELECT styleid, title FROM " . TABLE_PREFIX . "template WHERE templateid = " . $vbulletin->GPC['templateid']);

	if ($template)
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE templateid = " . $vbulletin->GPC['templateid']);
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "templatemerge WHERE templateid = " . $vbulletin->GPC['templateid']);

		print_rebuild_style($template['styleid'], '', 0, 0, 0, 0);
	}

	if (strpos($template['title'], 'bbcode_') === 0)
	{
		// begins with bbcode_ - empty the post parsed cache
		$vbulletin->db->query_write("TRUNCATE TABLE " . TABLE_PREFIX . "postparsed");
	}

	?>
	<script type="text/javascript">
	<!--

	// refresh the opening window (used for the revert updated default templates action)
	if (window.opener && String(window.opener.location).indexOf("template.php?do=findupdates") != -1)
	{
		window.opener.window.location = window.opener.window.location;
	}

	//-->
	</script>
	<?php
	print_cp_redirect("apm_product.php?" . $vbulletin->session->vars['sessionurl'] . "do=managedetails&amp;productid=" . $vbulletin->GPC['productid'] . "&amp;showtemplates=" . $vbulletin->GPC['showtemplates'], 1);

}

// #############################################################################
// confirmation for template deletion
if ($_REQUEST['do'] == 'delete')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'group' => TYPE_STR,
		'productid' => TYPE_STR,
		'showtemplates' => TYPE_UINT,
	));

	$hidden = array();
	$hidden['group'] = $vbulletin->GPC['group'];
	$hidden['productid'] = $vbulletin->GPC['productid'];
	$hidden['showtemplates'] = $vbulletin->GPC['showtemplates'];
	print_delete_confirmation('template', $vbulletin->GPC['templateid'], 'apm_template', 'kill', 'template', $hidden, $vbphrase['please_be_aware_template_is_inherited']);
}

// #############################################################################
// lets the user see the original template
if ($_REQUEST['do'] == 'view')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'title' => TYPE_STR
	));

	$template = $db->query_first("
		SELECT templateid, styleid, title, template_un
		FROM " . TABLE_PREFIX . "template
		WHERE styleid = -1 AND title = '" . $db->escape_string($vbulletin->GPC['title']) . "'
	");

	print_form_header('', '');
	print_table_header($vbphrase['show_default']);
	print_textarea_row($template['title'], '--[-ORIGINAL-TEMPLATE-]--', $template['template_un'], 20, 80, true, true, 'ltr', 'code');
	print_table_footer();
}


// #############################################################################
// update display order values
if ($_POST['do'] == 'dodisplayorder')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'displayorder' => TYPE_ARRAY_INT,
		'userselect'   => TYPE_ARRAY_INT,
	));

	$styles = $db->query_read("SELECT styleid, parentid, title, displayorder, userselect FROM " . TABLE_PREFIX . "style");
	if ($db->num_rows($styles))
	{
		while ($style = $db->fetch_array($styles))
		{
			$order = $vbulletin->GPC['displayorder']["{$style['styleid']}"];
			$uperm = intval($vbulletin->GPC['userselect']["{$style['styleid']}"]);
			if ($style['displayorder'] != $order OR $style['userselect'] != $uperm)
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "style
					SET displayorder = $order,
					userselect = $uperm
					WHERE styleid = $style[styleid]
				");
			}
		}
	}

	$_REQUEST['do'] = "modify";

	build_style_datastore();

}

// #############################################################################
// main template list display
if ($_REQUEST['do'] == 'modify')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'productid'		=> TYPE_STR,
		'searchset'    => TYPE_INT,
		'expandset'    => TYPE_NOHTML,
		'searchstring' => TYPE_STR,
		'titlesonly'   => TYPE_BOOL,
		'group'        => TYPE_NOHTML,
	));

	// populate the stylecache
	cache_styles();

	// sort out parameters for searching
	if ($vbulletin->GPC['searchstring'])
	{
		$vbulletin->GPC['group'] = 'all';
		if ($vbulletin->GPC['searchset'] > 0)
		{
			$vbulletin->GPC['expandset'] =& $vbulletin->GPC['searchset'];
		}
		else
		{
			$parentlist = '-1';
			$vbulletin->GPC['expandset'] = 'all';
		}
	}
	else
	{
		$vbulletin->GPC['searchstring'] = '';
	}

	if (is_numeric($vbulletin->GPC['expandset']))
	{
		$style = $db->query_first("SELECT parentlist FROM " . TABLE_PREFIX . "style WHERE styleid = " . $vbulletin->GPC['expandset']);
		$parentlist = $style['parentlist'];
	}

	// all browsers now support the enhanced template editor
	if (true)
	{
		define('FORMTYPE', 1);
		$SHOWTEMPLATE = 'construct_template_option';
	}
	else
	{
		define('FORMTYPE', 0);
		$SHOWTEMPLATE = 'construct_template_link';
	}

	if ($vbulletin->debug)
	{
		$JS_STYLETITLES[] = "\"0\" : \"" . $vbphrase['master_style'] . "\"";
		$prepend = '--';
	}

	foreach($stylecache AS $style)
	{
		$JS_STYLETITLES[] = "\"$style[styleid]\" : \"" . addslashes_js($style['title'], '"') . "\"";
		$JS_STYLEPARENTS[] = "\"$style[styleid]\" : \"$style[parentid]\"";
	}

	$JS_MONTHS = array();
	$i = 0;
	$months = array('january', 'february', 'march', 'april', 'may', 'june', 'july', 'august', 'september', 'october', 'november', 'december');
	foreach($months AS $month)
	{
		$JS_MONTHS[] = "\"$i\" : \"" . $vbphrase["$month"] . "\"";
		$i++;
	}

	foreach (array(
		'click_the_expand_collapse_button',
		'this_template_has_been_customized_in_a_parent_style',
		'this_template_has_not_been_customized',
		'this_template_has_been_customized_in_this_style',
		'template_last_edited_js',
		'x_templates'
		) AS $phrasename)
	{
		$JS_PHRASES[] = "\"$phrasename\" : \"" . fetch_js_safe_string($vbphrase["$phrasename"]) . "\"";
	}

?>

<script type="text/javascript">
<!--
var SESSIONHASH = "<?php echo $vbulletin->session->vars['sessionhash']; ?>";
var EXPANDSET = "<?php echo $vbulletin->GPC['expandset']; ?>";
var GROUP = "<?php echo $vbulletin->GPC['group']; ?>";
var SEARCHSTRING = "<?php echo urlencode($vbulletin->GPC['searchstring']); ?>";
var STYLETITLE = { <?php echo implode(', ', $JS_STYLETITLES); ?> };
var STYLEPARENTS = { <?php echo implode(', ', $JS_STYLEPARENTS); ?> };
var MONTH = { <?php echo implode(', ', $JS_MONTHS); ?> };
var vbphrase = {
	<?php echo implode(",\r\n\t", $JS_PHRASES) . "\r\n"; ?>
};

// -->
</script>

<?php
if (!FORMTYPE)
{
	print_form_header('', '');
	print_table_header("$vbphrase[styles] &amp; $vbphrase[templates]");
	print_description_row('
		<div class="darkbg" style="border: 2px inset"><ul class="darkbg">
		<li><b>' . $vbphrase['color_key'] . '</b></li>
		<li class="col-g">' . $vbphrase['template_is_unchanged_from_the_default_style'] . '</li>
		<li class="col-i">' . $vbphrase['template_is_inherited_from_a_parent_style'] . '</li>
		<li class="col-c">' . $vbphrase['template_is_customized_in_this_style'] . '</li>
		</ul></div>
	');
	print_table_footer();
}
else
{
	echo "<br />\n";
}

if ($help = construct_help_button('', NULL, '', 1))
{
	$pagehelplink = "<div style=\"float:" . vB_Template_Runtime::fetchStyleVar('right') . "\">$help</div>";
}
else
{
	$pagehelplink = '';
}

?>

<form action="apm_template.php" method="post" tabindex="1" name="tform">
<input type="hidden" name="do" value="dodisplayorder" />
<input type="hidden" name="s" value="<?php echo $vbulletin->session->vars['sessionhash']; ?>" />
<input type="hidden" name="adminhash" value="<?php echo ADMINHASH; ?>" />
<input type="hidden" name="expandset" value="<?php echo $vbulletin->GPC['expandset']; ?>" />
<input type="hidden" name="group" value="<?php echo $vbulletin->GPC['group']; ?>" />
<div align="center">
<div class="tborder" style="width:90%; text-align:<?php echo vB_Template_Runtime::fetchStyleVar('left'); ?>">
<div class="tcat" style="padding:4px; text-align:center"><?php echo $pagehelplink; ?><b><?php echo $vbphrase['style_manager']; ?></b></div>
<div class="stylebg">

<?php

	if (!empty($vbulletin->GPC['expandset']))
	{
		DEVDEBUG("Querying master template ids");
		$masters = $db->query_read("
			SELECT templateid, title
			FROM " . TABLE_PREFIX . "template
			WHERE templatetype = 'template'
				AND styleid IN (-1,0)
			ORDER BY title
		");
		while ($master = $db->fetch_array($masters))
		{
			$masterset["$master[title]"] = $master['templateid'];
		}
	}
	else
	{
		$masterset = array();
	}

	$LINKEXTRA = '';
	if (!empty($vbulletin->GPC['group']))
	{
		$LINKEXTRA .= "&amp;group=" . $vbulletin->GPC['group'];
	}
	if (!empty($vbulletin->GPC['searchstring']))
	{
		$LINKEXTRA .= "&amp;searchstring=" . urlencode($vbulletin->GPC['searchstring']) . "&amp;searchset=" . $vbulletin->GPC['searchset'];
	}
/*
	if ($vbulletin->debug)
	{
		print_style(-1);
	}
	foreach($stylecache AS $styleid => $style)
	{
		print_style($styleid, $style);
	}
*/
?>
</div>
<table cellpadding="2" cellspacing="0" border="0" width="100%" class="tborder" style="border: 0px">
<tr>
	<td class="tfoot" align="center">
		<input type="submit" class="button" tabindex="1" value="<?php echo $vbphrase['save_display_order']; ?>" />
		<input type="button" class="button" tabindex="1" value="<?php echo $vbphrase['search_in_templates']; ?>" onclick="window.location='apm_template.php?<?php echo $vbulletin->session->vars['sessionurl_js']; ?>do=search';" />
	</td>
</tr>
</table>
</div>
</div>
</form>
<?php

	echo '<p align="center" class="smallfont">' .
		construct_link_code($vbphrase['add_new_style'], "apm_template.php?" . $vbulletin->session->vars['sessionurl'] . "do=addstyle");
	if ($vbulletin->debug)
	{
		echo construct_link_code($vbphrase['rebuild_all_styles'], "apm_template.php?" . $vbulletin->session->vars['sessionurl'] . "do=rebuild&amp;goto=apm_template.php?" . $vbulletin->session->vars['sessionurl']) .
		construct_link_code('Compare Remote/Local Global Templates', '../docs/templatedev.php" target="templatedev', 0);
	}
	echo "</p>\n";


	// search only
	/*
	print_form_header('apm_template', 'modify');
	print_table_header($vbphrase['search_templates']);
	construct_hidden_code('searchset', -1);
	construct_hidden_code('titlesonly', 0);
	print_input_row($vbphrase['search_for_text'], 'searchstring', $vbulletin->GPC['searchstring']);
	print_description_row('<input type="button" value="Submit with GET" onclick="window.location = (\'apm_template.php?do=modify&amp;searchset=-1&amp;searchstring=\' + this.form.searchstring.value)" />');
	print_submit_row($vbphrase['find']);
	*/

}

// #############################################################################
// rebuilds all parent lists and id cache lists
if ($_REQUEST['do'] == 'rebuild')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'renumber' => TYPE_INT,
		'install'  => TYPE_INT,
		'goto'     => TYPE_STR
	));

	echo "<p>&nbsp;</p>";

	build_all_styles($vbulletin->GPC['renumber'], $vbulletin->GPC['install'], "apm_template.php?" . $vbulletin->session->vars['sessionurl']);
}

// #############################################################################
// create template files

if ($_REQUEST['do'] == 'createfiles' AND $vbulletin->debug)
{
	// this action requires that a web-server writable folder called
	// 'template_dump' exists in the root of the vbulletin directory

	if (is_demo_mode())
	{
		print_cp_message('This function is disabled within demo mode');
	}

	if (function_exists('set_time_limit') AND !SAFEMODE)
	{
		@set_time_limit(1200);
	}

	chdir(DIR . '/template_dump');

	$templates = $db->query_read("
		SELECT title, templatetype, username, dateline, template_un AS template
		FROM " . TABLE_PREFIX . "template
		WHERE styleid = " . $vbulletin->GPC['dostyleid'] . "
			AND templatetype = 'template'
			" . iif($vbulletin->GPC['mode'] == 1, "AND templateid IN($templateids)") . "
		ORDER BY title
	");
	echo "<ol>\n";
	while ($template = $db->fetch_array($templates))
	{
		echo "<li><b class=\"col-c\">$template[title]</b>: Parsing... ";
		$text = str_replace("\r\n", "\n", $template['template']);
		$text = str_replace("\n", "\r\n", $text);
		echo 'Writing... ';
		$fp = fopen("./$template[title].htm", 'w+');
		fwrite($fp, $text);
		fclose($fp);
		echo "<span class=\"col-i\">Done</span></li>\n";
	}
	echo "</ol>\n";
}

// #############################################################################
// hex convertor
if ($_REQUEST['do'] == 'colorconverter')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'hex'    => TYPE_NOHTML,
		'rgb'    => TYPE_NOHTML,
		'hexdec' => TYPE_STR,
		'dechex' => TYPE_STR,
	));

	if ($vbulletin->GPC['dechex'])
	{
		$vbulletin->GPC['rgb'] = preg_split('#\s*,\s*#si', $vbulletin->GPC['rgb'], -1, PREG_SPLIT_NO_EMPTY);
		$vbulletin->GPC['hex'] = '#';
		foreach ($vbulletin->GPC['rgb'] AS $i => $value)
		{
			$vbulletin->GPC['hex'] .= strtoupper(str_pad(dechex($value), 2, '0', STR_PAD_LEFT));
		}
		$vbulletin->GPC['rgb'] = implode(',', $vbulletin->GPC['rgb']);
	}
	else if ($vbulletin->GPC['hexdec'])
	{
		if (preg_match('/#?([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})/siU', $vbulletin->GPC['hex'], $matches))
		{
			$vbulletin->GPC['rgb'] = array();
			for ($i = 1; $i <= 3; $i++)
			{
				$vbulletin->GPC['rgb'][] = hexdec($matches["$i"]);
			}
			$vbulletin->GPC['rgb'] = implode(',', $vbulletin->GPC['rgb']);
			$vbulletin->GPC['hex'] = strtoupper("#$matches[1]$matches[2]$matches[3]");
		}
	}

	print_form_header('apm_template', 'colorconverter');
	print_table_header('Color Converter');
	print_label_row('Hexadecimal Color (#xxyyzz)', "<span style=\"padding:4px; background-color:" . $vbulletin->GPC['hex'] . "\"><input type=\"text\" class=\"bginput\" name=\"hex\" value=\"" . $vbulletin->GPC['hex'] . "\" size=\"20\" maxlength=\"7\" /> <input type=\"submit\" class=\"button\" name=\"hexdec\" value=\"Hex &raquo; RGB\" /></span>");
	print_label_row('RGB Color (r,g,b)', "<span style=\"padding:4px; background-color:rgb(" . $vbulletin->GPC['rgb'] . ")\"><input type=\"text\" class=\"bginput\" name=\"rgb\" value=\"" . $vbulletin->GPC['rgb'] . "\" size=\"20\" maxlength=\"11\" /> <input type=\"submit\" class=\"button\" name=\"dechex\" value=\"RGB &raquo; Hex\" /></span>");
	print_table_footer();
}

print_cp_footer();

/*======================================================================*\
|| #################################################################### ||
|| # CVS: apm_template.php,v 4.0.001 - Revision: 091203
|| # ref: $RCSfile: template.php,v $ - $Revision: 32878 $
|| #################################################################### ||
\*======================================================================*/
?>
